// C++ program for the above approach
#include <bits/stdc++.h>
using namespace std;

// Function to generate a matrix with
// sum of each row equal to sum of r[]
// and sum of each column equal to sum of c[]
vector<vector<int> > restoreGem(
	vector<int>& r, vector<int>& c)
{
	// Initialize a matrix
	vector<vector<int> > dp(r.size(),
							vector<int>(c.size(), 0));

	// Traverse each cell (i, j) of the matrix
	for (int i = 0; i < r.size(); i++) {
		for (int j = 0; j < c.size(); j++) {

			// Assign the minimum of the
			// row or column value
			int m = min(r[i], c[j]);
			dp[i][j] = m;

			// Subtract the minimum from
			// both row and column sum
			r[i] -= m;
			c[j] -= m;
		}
	}

	return dp;
}

void printMatrix(vector<vector<int> > ans,
				int N, int M)
{
    int k=0;
    int suma=0;
    for (int i = 0; i < N; i++) {
		for (int j = 0; j < M; j++) {
                if(ans[i][j]!=0){
                    k++;
                    suma+=ans[i][j];
                }

		}

	}
	cout<<suma<<endl;
	cout<<k<<endl;

	// Print the matrix obtained
	for (int i = 0; i < N; i++) {
		for (int j = 0; j < M; j++) {
                if(ans[i][j]!=0){
                    cout<<i+1<<" "<<j+1<<" "<<ans[i][j]<<endl;
                }

		}

	}
}

// Driver Code
int main()
{
	//vector<int> rowSum = { 2, 2};
	//vector<int> colSum = { 1, 1, 2 };

    int n, m;
    cin >> n >> m;



    vector<int> rowSum(n),  colSum(m);
    for (int i = 0; i < n; i++) {
        cin >> rowSum[i] >> rowSum[i];
    }
    for (int j = 0; j < m; j++) {
        cin >> colSum[j] >> colSum[j];
    }

	vector<vector<int> > ans
		= restoreGem(rowSum, colSum);

	printMatrix(ans, rowSum.size(),
				colSum.size());




}